EvaluateSystemScript("clock.js");
EvaluateSystemScript("timed_animation.js");

// This is the main game file. All of the player's data is stored here.
function GameData()
{
	var t = new Object();
	t.money = 0;						// Current amount of money held by the party
	t.clock = new Clock()			// Game clock
	t.party = new Array();			// Characters that have joined
	t.psize = 1;							// Current size of party
	t.events = Events();				// Events that have happened in the game
	t.idolix = new Array();			// Idolix party has found
	t.menuopen = false;				// Is there a menu open?
	t.currentmenu;					// Menu that is open
	t.curBattle = undefined;		// Current battle
	t.battleopen = false;				// Is battle open?
	t.messageopen = false;			// Is there a message open
	t.submenu = new Menu(true);
	t.submenu.addItem("Inventory");
	t.submenu.addItem("Ability");
	t.submenu.addItem("Equipment");
	t.submenu.addItem("Status");
	t.submenu.addItem("Idolix");
	t.submenu.addItem("Customize");
	t.submenu.addItem("Tutorial");
	t.submenu.addItem("Save/Load");
	t.submenu.addItem("Exit Game");
	t.submenu.returnSelection = true;
	t.submenu.indent = 6;
	t.sound = undefined;
	t.messagex = 0;					// Open message's x value
	t.messagey = 0;					// Open message's y value
	t.messagew = 0;					// Open message's w value
	t.messagespeaker = "";			// Open message's speaker
	t.messagetext = "";				// Open message's text
	t.messageletter = 0;				// Open message's current letter
	t.messagetime = 0;				// Time until message disappears
	t.items = new Array();			// Items held by the party
	// The following will be placed into the game's config.dat and save file
	t.atb = "Wait";
	t.accept = KEY_A;				// Accept key
	t.cancel = KEY_SPACE;			// Cancel key
	t.menu = KEY_F;					// Menu key
	t.start = KEY_SHIFT;			// Start key (pausing and stuff)
	t.saveable = false;				// Is it possible to save
	t.freeze = false;					// Are the controls frozen
	t.area = false;						// Is there a submap warp here
	t.areax = 0;						// x coordinate of ShowArea()
	t.areay = 0;						// y coordinate of ShowArea()
	t.areatext = "";					// Name of current area
	t.areamap = "";					// Name of current map
	t.location = "";						// Name of location
	t.menu_move = LoadSound("Cursor-move.wav");
	t.menu_cancel = LoadSound("Cursor-cancel.wav");
	t.menu_delay = 100;				// Delay for menu control
	t.last_push = 0;					// Last time a key was pressed
	return t;
}

function FillIn()
{
	Game.submenu.doWhile = InfoWindow;
	Damizean.bMenu.items[0] = Commands.TAttack;
	Damizean.bMenu.items[1] = Commands.TBlackMag;
	Damizean.bMenu.items[2] = Commands.TSkill;
	Damizean.bMenu.items[3] = Commands.TItem;
	Damizean.commands[0] = Commands.TBlackMag;
	Damizean.commands[1] = Commands.TSkill;
	Damizean.commands[2] = Commands.TMess;
	Damizean.commands[3] = Commands.TItem;
	Damizean.bMenu.items[1].enabled = false;
	Damizean.bMenu.items[2].enabled = false;
	Damizean.bMenu.items[3].enabled = false;
	Annika.position = "Back";
	SetTalkActivationKey(Game.accept);
	SetTalkDistance(5);
	Game.items[0] = Items.Weapons[1].clone();
	Game.items[1] = Items.Weapons[2].clone();
	Enemies.Jude.item = Items.Weapons[1].clone();
}

// This warps the player to another map
function Warp(amap)
{
	ChangeMap(amap);
}

// Moves entities easily
function Move(person, direction, tiles)
{
	switch (direction)
	{
		case "east":
			QueuePersonCommand(person, COMMAND_FACE_EAST, true);
			for (var i = 0; i < tiles * 16; i ++)
			{
				QueuePersonCommand(person, COMMAND_MOVE_EAST, false);
			}
			break;
		case "west":
			QueuePersonCommand(person, COMMAND_FACE_WEST, true);
			for (var i = 0; i < tiles * 16; i ++)
			{
				QueuePersonCommand(person, COMMAND_MOVE_WEST, false);
			}
			break;
		case "south":
			QueuePersonCommand(person, COMMAND_FACE_SOUTH, true);
			for (var i = 0; i < tiles * 16; i ++)
			{
				QueuePersonCommand(person, COMMAND_MOVE_SOUTH, false);
			}
			break;
		case "north":
			QueuePersonCommand(person, COMMAND_FACE_NORTH, true);
			for (var i = 0; i < tiles * 16; i ++)
			{
				QueuePersonCommand(person, COMMAND_MOVE_NORTH, false);
			}
			break;
	}
}

// Makes the person wait
function Wait(person, seconds)
{
	for (var i = 0; i < seconds * 10; i ++)
	{
		QueuePersonCommand(person, COMMAND_WAIT, false);
	}
}

// Makes the person face the player
function FacePlayer(person)
{

}

// Random movement generator
function MoveRandomly(person, speed)
{
	if (Game.personTalking != person)
	{
		var direction = Math.floor(Math.random() * (6 + speed));
		var tiles = Math.floor(Math.random() * 2);
		switch (direction)
		{
			default:
				Wait(person, tiles * speed);
				break;
			case 1 + speed:
				Move(person, "north", tiles);
				break;
			case 2 + speed:
				Move(person, "south", tiles);
				break;
			case 3 + speed:
				Move(person, "east", tiles);
				break;
			case 4 + speed:
				Move(person, "west", tiles);
				break;
		}
	}
}

// Returns true or false if the event is on or off, depending on how it is used
function IsEvent(eventNum, onoff)
{
	if (Game.events[eventNum] == onoff)
	{
		return true;
	}
	else
		return false;
}

// This does all the spiffy intro stuff
function Introduction(fade_speed)
{
	this.events = new Array();
	this.bg = Colors.Black;
	this.current_event = 0;
	this.current_process = "FadeFrom";
	this.pressed = false;
	this.timer = 0;
	this.step = 255;
	this.fade_speed = fade_speed;
	this.music = false;
}

// Add a new event to the intro scene
Introduction.prototype.addEvent = function(type, file, wait)
{
	var event = new Object();
	event.type = type;
	if (type == "Image")
	{
		event.file = LoadImage(file);
	}
	if (type == "Text")
	{
		event.file = file;
	}
	if (type == "Animation")
	{
		event.file = new TimedAnimation(LoadAnimation(file));
	}
	event.wait = wait;
	this.events[this.events.length] = event;
}

// Play the intro scene
Introduction.prototype.play = function()
{
	var playing = true;
	if (this.music != false)
	{
		this.music.play(true);
	}
	while (playing)
	{
		ApplyColorMask(this.bg);
		if (this.events[this.current_event] != undefined)
		{
			if (this.events[this.current_event].type == "Image")
			{
				this.events[this.current_event].file.blit(GetScreenWidth() / 2 - (this.events[this.current_event].file.width / 2), GetScreenHeight() / 2 - (this.events[this.current_event].file.height / 2));
			}
			if (this.events[this.current_event].type == "Text")
			{
				font.title.drawText(GetScreenWidth() / 2 - (font.title.getStringWidth(this.events[this.current_event].file) / 2), GetScreenHeight() / 2 - 9, this.events[this.current_event].file);
			}
			if (this.events[this.current_event].type == "Animation")
			{
				this.events[this.current_event].file.blit(GetScreenWidth() / 2 - (this.events[this.current_event].file.animation.getWidth() / 2), GetScreenHeight() / 2 - (this.events[this.current_event].file.animation.getHeight() / 2));
			}
		}
		// Fade from
		if (this.current_process == "FadeFrom")
		{
			Fade(this.step, Colors.Black);
			this.step -= this.fade_speed;
			if (this.step < 0)
			{
				this.current_process = "Wait";
				this.timer = GetTime();
			}
		}
		if (this.current_process == "Wait")
		{
			if (this.timer + this.events[this.current_event].wait <= GetTime())
			{
				this.current_process = "FadeTo";
			}
		}
		// Fade to
		if (this.current_process == "FadeTo")
		{
			Fade(this.step, Colors.Black);
			this.step += this.fade_speed;
			if (this.step > 255)
			{
				if (this.pressed == false)
				{
					this.current_event ++;
					this.current_process = "FadeFrom";
				}
				if (this.pressed == true)
				{
					playing = false;
				}
			}
		}
		FlipScreen();
		if (this.events[this.current_event] == undefined)
		{
			playing = false;
		}
		if (IsKeyPressed(KEY_ENTER))
		{
			this.current_process = "FadeTo";
			this.pressed = true;
		}
	}
	if (this.music != false)
	{
		this.music.stop();
	}
}

function LastPush()
{
	if (Game.menu_delay + Game.last_push < GetTime())
	{
		return true;
	}
	else
		return false;
}

function KeyPressed(other)
{
	Game.last_push = GetTime();
	if (other != undefined)
	{
		Game.sound = Game.menu_cancel;
		Game.soundTime = GetTime();
		Game.sound.play(false);
	}
	else
	{
		Game.sound = Game.menu_move;
		Game.soundTime = GetTime();
		Game.sound.play(false);
	}
}

function Fade(step, color)
{
	ApplyColorMask(CreateColor(color.red, color.green, color.blue, step));
}

// This will return the correct radians from degrees
function DtR(degree)
{
	if (degree >= 0)
		return Math.PI * degree / 180;
	if (degree < 0)
		return Math.PI * (360 + degree) / 180;
}

function GetPartySize()
{
	var psize = Game.party.length;
	if (Game.party.length > 3)
	{
		psize = 3;
	}
	return psize;
}

function QuitMessage(message, heading)
{
	if (heading == undefined)
	{
		heading = "ERROR";
	}
	var sphere = LoadImage("Sphere.png");
	while (!IsKeyPressed(KEY_SHIFT))
	{
		sphere.blit(160 - sphere.width / 2, 120 - sphere.height / 2);
		font.title.drawText(160 - font.title.getStringWidth(heading) / 2, 40, heading);
		font.drawTextBox(40, 140, 240, 60, message);
		FlipScreen();
	}
	Exit();
}

function AilmentArray()
{
	var ailments = new Array();
	ailments[0] = false; // Poison
	ailments[1] = false; // Mute
	return ailments;
}

function ElementArray()
{
	var elements = new Array(8);
	elements[0] = 100; // Fire
	elements[1] = 100; // Ice
	elements[2] = 100; // Lightning
	elements[3] = 100; // Water
	elements[4] = 100; // Wind
	elements[5] = 100; // Earth
	elements[6] = 100; // Holy
	elements[7] = 100; // Shadow
	return elements;
}

function Interrupt()
{
	if (Game.sound != undefined && Game.soundTime + 310 <= GetTime())
	{
		Game.sound.stop();
		Game.sound = undefined;
	}
}